/*
 * GestionLlamadas.java
 *
 * Created on 20 de noviembre de 2007, 12:54
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package modelo;

import java.sql.*;
import java.util.*;
import javabeans.*;
import java.text.*;
public class GestionLlamadas {
   Datos dt;
   public GestionLlamadas(String driver, String cadenacon) {
        dt=new Datos(driver,cadenacon);
   }
   public ArrayList<LlamadaBean> getTodasLlamadasTelefono(int telefono){
       String query = "select * from llamadas where ";
       query+="telefono="+telefono;
       return getLlamadas(query,telefono); 
   } 
   public ArrayList<LlamadaBean> getLlamadasTelefonoPorTipoTarifa(int telefono, int idtipotarifa){
       String query = "select * from llamadas where ";
       query+="telefono="+telefono+" and idtipotarifa="+idtipotarifa;
       return getLlamadas(query,telefono); 
   }  
   //metodo que obtiene las llamadas, comn para los dos mtodos
   //anteriores
   private ArrayList<LlamadaBean> getLlamadas(String sql, int telefono){
        ArrayList<LlamadaBean> llamadas=new ArrayList<LlamadaBean>();
        try{
         Connection cn=dt.getConexion();
         Statement st =cn.createStatement();
         ResultSet rs = st.executeQuery(sql); 
         while(rs.next()){
             LlamadaBean llamada=new LlamadaBean();
             llamada.setTelefono(telefono);
             llamada.setDestino(rs.getInt("destino"));
             llamada.setDuracion(rs.getInt("duracion"));
             llamada.setTarifa(this.getTarifa(rs.getInt("idtipotarifa")));
             llamada.setCoste(rs.getDouble("coste"));
             llamada.setFecha(rs.getString("fecha"));
             llamadas.add(llamada);    
         }
         dt.cierraConexion(cn);
        }
        catch(Exception e){
             e.printStackTrace();
        }
        finally{
            return llamadas;
        }    
   }
   public ArrayList<LlamadaBean> getLlamadasTelefonoApartirFecha(int telefono, String fecha){
       ArrayList<LlamadaBean> llamadas=new ArrayList<LlamadaBean>();
       DateFormat feuropa=DateFormat.getDateInstance(DateFormat.SHORT,Locale.getDefault());
        try{
         Connection cn=dt.getConexion();
         String query = "select * from llamadas where ";
         query+="telefono="+telefono;
         Statement st =cn.createStatement();
         ResultSet rs = st.executeQuery(query); 
         while(rs.next()){
             //convierte las dos fechas a un formato comn para
             //poder compararlas
             java.util.Date fechallamada=rs.getDate("fecha");
             java.util.Date fechacomparacion=feuropa.parse(fecha);
             //almacena en el ArrayList nicamente las llamadas
             //cuya fecha sea posterior a la suministrada como
             //parmetro
             if(fechallamada.after(fechacomparacion)){
                 LlamadaBean llamada=new LlamadaBean();
                 llamada.setTelefono(telefono);
                 llamada.setDestino(rs.getInt("destino"));
                 llamada.setDuracion(rs.getInt("duracion"));
                 llamada.setTarifa(this.getTarifa(rs.getInt("idtipotarifa")));
                 llamada.setCoste(rs.getDouble("coste"));
                 llamada.setFecha(feuropa.format(fechallamada));
                 llamadas.add(llamada); 
             }
         }
         dt.cierraConexion(cn);
        }
        catch(Exception e){
             e.printStackTrace();
        }
        finally{
            return llamadas;
        }       
   }
   private String getTarifa(int id){
       String tarifa=null;
       try{
         Connection cn=dt.getConexion();
         String query = "select nombretarifa from tarifas ";
         query +="where idtipotarifa="+id;
         Statement st =cn.createStatement();
         ResultSet rs = st.executeQuery(query);
         if(rs.next()){
             tarifa=rs.getString("nombretarifa");
         }
         dt.cierraConexion(cn);
       }
       catch(Exception e){
            e.printStackTrace();
       }
       finally{
           return tarifa;
       }
   }
}
